'==========================================================================
'
' Author......: Raffaele Chiatto
'
' WebSite.....: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================

Option Explicit 

Dim Text, Title
Dim WshShell    ' Object variable
Dim status, Ready_txt
Dim Shortcut, Path

Ready_txt = "Shortcut created"
Text = _
    "Crea il collegamento al Notepad all'interno dello Start Men (Group ""Chiatto"")"
Title = "Raffaele Chiatto Produced"

' Ask user whether to create shortcut.
status =  MsgBox(Text, _
                 vbOKCancel + vbInformation, _
                 Title)
If (status <> vbOK) Then
    WScript.Quit 1         ' Cancel selected.
End If

' Create WshShell object, which is needed for the
' WshSpecialFolders object.
Set WshShell = WScript.CreateObject("WScript.Shell")

' Get path to the folder Startmenu/Programs using
' the WshSpecialFolders object.
Path = WSHShell.SpecialFolders("Programs")

' Important: Entry goes into Programs\Chiatto.
Path = Path & "\Chiatto\"

' Check whether path exists; if not, create group.
MakePath Path

' We know the path to the Start menu; create shortcut using 
' the CreateShortcut method.
Set Shortcut = WshShell.CreateShortcut(Path & "Editor.lnk")

' Set shortcut properties.
' Target path
Shortcut.TargetPath = _
    WshShell.ExpandEnvironmentStrings("%WINDIR%\Notepad.exe")

' Working directory
Shortcut.WorkingDirectory = _
    WshShell.ExpandEnvironmentStrings("%WINDIR%")

' Windows style 1 = normal, 3 = maximized, 7 = minimized
Shortcut.WindowStyle = 1  

' Shortcut icon
Shortcut.IconLocation = _
    WshShell.ExpandEnvironmentStrings("%WINDIR%\Notepad.exe, 0")

' Hot key for shortcut
Shortcut.Hotkey = "Alt+CtrL+E"

Shortcut.Save              ' Create shortcut.

WScript.Echo Ready_txt     ' Show ready message.

Sub MakePath(pathx)
    On Error Resume Next
    ' Create folder if it doesn't exist.  

    Dim fso, f
    Set fso = CreateObject("Scripting.FileSystemObject")
    Set f = fso.CreateFolder(pathx)
    Set fso = Nothing
    Set f = Nothing
    On Error GoTo 0
End Sub

'*** End

